/*
 * PotentialFactory.hpp
 *
 *  Created on: 30.11.2012
 *      Author: heber
 */

#ifndef POTENTIALFACTORY_HPP_
#define POTENTIALFACTORY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "CodePatterns/Singleton.hpp"

#include "Potentials/EmpiricalPotential.hpp"
#include "Potentials/Specifics/PotentialTypes.hpp"

/** Class that creates instances of potentials.
 *
 * This is a factory pattern.
 *
 */
class PotentialFactory : public Singleton<PotentialFactory>
{
  //!> make Singleton template friend
  friend class Singleton<PotentialFactory>;

public:
  /** Creates an instance of the requested potential.
   *
   * \param potentialtype key of potential to create
   * \param charges charges for which the potential is (to be) fitted
   */
  EmpiricalPotential *createInstance(
      const std::string &potentialtype,
      const SerializablePotential::ParticleTypes_t &charges) const;

  //!> typedef for map to lookup type for a given name
  typedef std::map< std::string, enum PotentialTypes > NameToType_t;

  //!> map for looking up type to a given name
  static NameToType_t NameToType;

  //!> typedef for map to lookup name for a given type
  typedef std::map< enum PotentialTypes,std::string > TypeToName_t;

  //!> map for looking up type to a given name
  static TypeToName_t TypeToName;

private:
  PotentialFactory() {}
  ~PotentialFactory() {}
};

#endif /* POTENTIALFACTORY_HPP_ */
