/*
 * HistogramUnitTest.hpp
 *
 *  Created on: Jul 26, 2012
 *      Author: heber
 */

#ifndef HISTOGRAMUNITTEST_HPP_
#define HISTOGRAMUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

class Histogram;

/********************************************** Test classes **************************************/

class HistogramTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( HistogramTest) ;
    CPPUNIT_TEST ( internalState_Test );
    CPPUNIT_TEST ( getLowerEndBin_Test );
    CPPUNIT_TEST ( getHigherEndBin_Test );
    CPPUNIT_TEST ( getLowerEnd_Test );
    CPPUNIT_TEST ( isEmpty_Test );
    CPPUNIT_TEST ( areaTest );
    CPPUNIT_TEST ( superposeOtherHistogram_Test );
    CPPUNIT_TEST ( operatorPlusEqual_Test );
    CPPUNIT_TEST ( operatorMinusEqual_Test );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void internalState_Test();
      void getLowerEndBin_Test();
      void getHigherEndBin_Test();
      void getLowerEnd_Test();
      void isEmpty_Test();
      void areaTest();
      void superposeOtherHistogram_Test();
      void operatorPlusEqual_Test();
      void operatorMinusEqual_Test();

private:
      Histogram *histogram;

};

#endif /* HISTOGRAMUNITTEST_HPP_ */
