/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculeTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include <Descriptors/MoleculeDescriptor.hpp>
#include <Descriptors/MoleculeIdDescriptor.hpp>
#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"


TextDialog::MoleculeTextQuery::MoleculeTextQuery(string title, std::string _description) :
    Dialog::MoleculeQuery(title,_description)
{}

TextDialog::MoleculeTextQuery::~MoleculeTextQuery() {}

bool TextDialog::MoleculeTextQuery::handle() {
  int idxOfMol=0;
  bool badInput = false;
  do{
    badInput = false;
    std::cout << getDescription() << ": ";
    std::cin >> idxOfMol;
    if(std::cin.fail()){
      badInput = true;
      std::cin.clear();
      std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
      std::cout << "Input was not a number!" << std::endl;
      continue;
    }

    tmp = World::getInstance().getMolecule(MoleculeById(idxOfMol));
    if(!tmp && idxOfMol!=-1){
      std::cout << "Invalid Molecule Index" << std::endl;
      badInput = true;
    }

  } while(badInput);
  std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
  return (idxOfMol!=-1);
}


