/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * CommandLineStatusIndicator.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CommandLineUI/CommandLineStatusIndicator.hpp"

#include <iostream>

#include "Actions/Process.hpp"

using namespace MoleCuilder;

CommandLineStatusIndicator::CommandLineStatusIndicator() :
    Observer("CommandLineStatusIndicator")
{
  Process::AddObserver(this);
}

CommandLineStatusIndicator::~CommandLineStatusIndicator()
{
  Process::RemoveObserver(this);
}

void CommandLineStatusIndicator::update(Observable *subject){
  Process *proc;
  // we are only observing Processes
  if((proc=dynamic_cast<Process*>(subject))){
    // see what kind of progress we have to display
    if(proc->getMaxSteps()>0){
      if(!proc->doesStop()){
        std::cout << "Busy (" << proc->getName() << ") ";
        // we can show a percentage done
        std::cout << (int)proc->getDoneRatio() << "% done" << std::endl;
      }
    }
    else{
      // we only show some kind of busy animation
      if(proc->doesStart()){
        std::cout << "Busy (" << proc->getName() << ")";
      }
      if(!proc->doesStop()){
        std::cout << ".";
      }
      else {
        std::cout << std::endl;
      }
    }
  }
}

void CommandLineStatusIndicator::subjectKilled(Observable *subject){

}

