/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * RandomNumberGeneratorFactoryUnitTest.cpp
 *
 *  Created on: Jan 03, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "CodePatterns/Assert.hpp"

#include "RandomNumberGeneratorFactoryUnitTest.hpp"

#include "RandomNumbers/RandomNumberGenerator.hpp"
#include "RandomNumbers/RandomNumberEngineFactory.hpp"
#include "RandomNumbers/RandomNumberDistributionFactory.hpp"
#include "RandomNumbers/RandomNumberGeneratorFactory.hpp"

#include <boost/nondet_random.hpp>
#include <boost/random.hpp>
#include <boost/random/additive_combine.hpp>
#include <boost/random/discard_block.hpp>
#include <boost/random/inversive_congruential.hpp>
#include <boost/random/lagged_fibonacci.hpp>
#include <boost/random/linear_congruential.hpp>
#include <boost/random/linear_feedback_shift.hpp>
#include <boost/random/mersenne_twister.hpp>
#include <boost/random/random_number_generator.hpp>
#include <boost/random/ranlux.hpp>
#include <boost/random/shuffle_output.hpp>
#include <boost/random/subtract_with_carry.hpp>
#include <boost/random/xor_combine.hpp>
#include <boost/random/bernoulli_distribution.hpp>
#include <boost/random/binomial_distribution.hpp>
#include <boost/random/cauchy_distribution.hpp>
#include <boost/random/exponential_distribution.hpp>
#include <boost/random/gamma_distribution.hpp>
#include <boost/random/geometric_distribution.hpp>
#include <boost/random/linear_congruential.hpp>
#include <boost/random/lognormal_distribution.hpp>
#include <boost/random/normal_distribution.hpp>
#include <boost/random/poisson_distribution.hpp>
#include <boost/random/triangle_distribution.hpp>
#include <boost/random/uniform_01.hpp>
#include <boost/random/uniform_int.hpp>
#include <boost/random/uniform_on_sphere.hpp>
#include <boost/random/uniform_real.hpp>
#include <boost/random/uniform_smallint.hpp>

#include <typeinfo>

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( RandomNumberGeneratorFactoryTest );

void RandomNumberGeneratorFactoryTest::setUp()
{
  RandomNumberGeneratorFactory::getInstance();
}

void RandomNumberGeneratorFactoryTest::tearDown()
{

  RandomNumberDistributionFactory::purgeInstance();
  RandomNumberEngineFactory::purgeInstance();
  RandomNumberGeneratorFactory::purgeInstance();
}

void RandomNumberGeneratorFactoryTest::GeneratorTest()
{
  // check one of the engines and distributions
  RandomNumberGenerator& rng = *(RandomNumberGeneratorFactory::getInstance().
      GeneratorPrototypeTable[RandomNumberEngineFactory::minstd_rand0]
                              [RandomNumberDistributionFactory::uniform_smallint]);
  CPPUNIT_ASSERT_EQUAL(
      std::string(typeid(boost::minstd_rand0).name()),
      rng.EngineName()
  );
  CPPUNIT_ASSERT_EQUAL(
      std::string(typeid(boost::uniform_smallint<> ).name()),
      rng.DistributionName()
  );

  // set types in lower factories
  RandomNumberEngineFactory::getInstance().setCurrentType(RandomNumberEngineFactory::minstd_rand0);
  RandomNumberDistributionFactory::getInstance().setCurrentType(RandomNumberDistributionFactory::uniform_int);
  // ... and check whether generator delivers those set types
  RandomNumberGenerator &rng_A = RandomNumberGeneratorFactory::getInstance().
      makeRandomNumberGenerator();
  CPPUNIT_ASSERT_EQUAL(
      std::string(typeid(boost::minstd_rand0).name()),
      rng_A.EngineName()
  );
  CPPUNIT_ASSERT_EQUAL(
      std::string(typeid(boost::uniform_int<> ).name()),
      rng_A.DistributionName()
  );
}
