/*
 * linkedcell.hpp
 *
 *  If the linked cell should be usable, the class has to inherit LCNodeSet and the nodes (containing the Vectors) have to inherit LCNode. This works well
 *  for molecule and atom classes.
 *
 *  Created on: Aug 3, 2009
 *      Author: heber
 */

#ifndef LINKEDCELL_HPP_
#define LINKEDCELL_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <list>

#include "defs.hpp"
#include "vector.hpp"

/****************************************** forward declarations *****************************/

class PointCloud;
class TesselPoint;

/********************************************** definitions *********************************/

#define LinkedNodes list<TesselPoint *>

/********************************************** declarations *******************************/

/** Linked Cell class for containing Vectors in real space efficiently.
 */
class LinkedCell {
  public:
    Vector max;       // upper boundary
    Vector min;       // lower boundary
    LinkedNodes *LC;  // linked cell list
    double RADIUS;    // cell edge length
    int N[NDIM];      // number of cells per axis
    int n[NDIM];      // temporary variable for current cell per axis
    int index;        // temporary index variable , access by index = n[0] * N[1] * N[2] + n[1] * N[2] + n[2];

    LinkedCell();
    LinkedCell(PointCloud *set, double RADIUS);
    LinkedCell(LinkedNodes *set, double radius);
    ~LinkedCell();
    LinkedNodes* GetCurrentCell();
    bool SetIndexToNode(const TesselPoint *Walker);
    bool SetIndexToVector(const Vector *x);
    bool CheckBounds();
    void GetNeighbourBounds(int lower[NDIM], int upper[NDIM]);

    // not implemented yet
    bool AddNode(Vector *Walker);
    bool DeleteNode(Vector *Walker);
    bool MoveNode(Vector *Walker);
};

#endif /*LINKEDCELL_HPP_*/
