/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

 /** \file builder.cpp
 *
 *  date: Jan 1, 2007
 *  author: heber
 *
 */

/*! \page Copyright notice
 *
 *  MoleCuilder - to create and alter molecular systems
 *  Copyright (C) 2010  University Bonn. All rights reserved.
 *
 */

/*! \mainpage MoleCuilder - a molecular set builder
 *
 * This introductory shall briefly make acquainted with the program, helping in installing and a first run.
 *
 * \section about About the Program
 *
 *  MoleCuilder is a program, written entirely in C++, that enables the construction of a coordinate set for the
 *  atoms making up an molecule. It allows for both building of simple molecules by adding atom-wise giving bond
 *  angles and distances or absolute coordinates, but also using them as templates. Regions can be specified and
 *  ordered to be filled with a molecule in a certain manner. Greater conglomerations of molecules can be tesselated
 *  and recognized as a region themselves to be subsequently surrounded by other (surface solvated) molecules.
 *  In the end, MoleCuilder allows the construction of arbitrary nano structures, whether they be crystalline or
 *  amorphic in nature.
 *
 *
 * \section install Installation
 *
 *  Installation should without problems succeed as follows:
 *  -# ./configure (or: mkdir build;mkdir run;cd build; ../configure --bindir=../run)
 *  -# make
 *  -# make install
 *
 *  Further useful commands are
 *  -# make clean uninstall: deletes .o-files and removes executable from the given binary directory\n
 *  -# make doxygen-doc: Creates these html pages out of the documented source
 *  -# make check: Runs an extensive set of unit tests and a testsuite which also gives a good overview on the set of
 *                 functions.
 *
 * \section run Running
 *
 *  The program can be executed by running: ./molecuilder
 *
 *  MoleCuilder has three interfaces at your disposal:
 *  -# Textmenu: A simple interactive console-based menu, where awaits your choices and inputs in order to set atoms
 *               as you like
 *  -# CommandLineUI: Every command can also be chained up as a sequence of actions on the command line to be executed
 *               with any user interaction.
 *  -# GraphicalUI: A graphical user interface that also display the molecular structure being built and lots of other
 *               informations to ease the construction of bigger geometries.
 *
 *  The supported output formats right now are:
 *  -# mpqc: Configuration files of the Massively Parallel Quantum Chemistry package (Sandia labs)
 *  -# pcp: Configuration files of the Parallel Car-Parrinello program (Institute for Numerical Simulation)
 *  -# tremolo: Configuration files of TREMOLO (Institute for Numerical Simulation)
 *  -# xyz: the most basic format for the 3d arrangement of atoms consisting of a list of element and 3 coordinates.
 *
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "builder_init.hpp"

/********************************************** Main routine **************************************/

int main(int argc, char **argv)
{
  initGeneral();

  initUI(argc,argv);

  doUI();

  return saveAll();
}

/********************************************** E N D **************************************************/
