/*
 * GlobalListOfActions.hpp
 *
 *  Created on: Sep 21, 2011
 *      Author: heber
 */

#ifndef GLOBALLISTOFACTIONS_HPP_
#define GLOBALLISTOFACTIONS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/preprocessor/seq/push_back.hpp>
#include <boost/preprocessor/seq/remove.hpp>

// this is global list of actions valid for all cases
// PLEASE adhere to the alphabetical ordering of the list of Actions
// NOTE that Redo must remain at the front due to technical reasons
#define GLOBALLISTOFACTIONS_initial \
  (Redo) \
  (AnalysisAverageMoleculeForce) \
  (AnalysisDipoleAngularCorrelation) \
  (AnalysisDipoleCorrelation) \
  (AnalysisMolecularVolume) \
  (AnalysisPairCorrelation) \
  (AnalysisPointCorrelation) \
  (AnalysisPrincipalAxisSystem) \
  (AnalysisSurfaceCorrelation) \
  (AtomAdd) \
  (AtomChangeElement) \
  (AtomMirror) \
  (AtomRemove) \
  (AtomRotateAroundOriginByAngle) \
  (AtomSaturate) \
  (AtomSaveSelectedAtoms) \
  (AtomTranslate) \
  (AtomTranslateToOrigin) \
  (BondAdd) \
  (BondRemove) \
  (CommandDryRun) \
  (CommandElementDb) \
  (CommandBondLengthTable) \
  (CommandFastParsing) \
  (CommandHelp) \
  (CommandHelpRedistribute) \
  (CommandNoDryRun) \
  (CommandSetRandomNumbersEngine) \
  (CommandSetRandomNumbersDistribution) \
  (CommandStoreSession) \
  (CommandVerbose) \
  (CommandVersion) \
  (CommandWarranty) \
  (FillRegularGrid) \
  (FillSurface) \
  (FillSuspendInMolecule) \
  (FillVolume) \
  (FragmentationAnalyseFragmentationResults) \
  (FragmentationClearFragmentationResults) \
  (FragmentationFragmentation) \
  (FragmentationFragmentationAutomation) \
  (FragmentationMolecularDynamics) \
  (FragmentationParseFragmentJobs) \
  (FragmentationStoreSaturatedFragment) \
  (FragmentationStructuralOptimization) \
  (GraphUpdateMolecules) \
  (GraphCorrectBondDegree) \
  (GraphCreateAdjacency) \
  (GraphDepthFirstSearch) \
  (GraphDestroyAdjacency) \
  (GraphSubgraphDissection) \
  (MoleculeBondFile) \
  (MoleculeChangeName) \
  (MoleculeChangeBondAngle) \
  (MoleculeCopy) \
  (MoleculeForceAnnealing) \
  (MoleculeLinearInterpolationofTrajectories) \
  (MoleculeLoad) \
  (MoleculeRemove) \
  (MoleculeRotateAroundSelfByAngle) \
  (MoleculeRotateToPrincipalAxisSystem) \
  (MoleculeSaveAdjacency) \
  (MoleculeSaveBonds) \
  (MoleculeSaveSelectedMolecules) \
  (MoleculeSaveTemperature) \
  (MoleculeStretchBond) \
  (MoleculeTranslate) \
  (MoleculeVerletIntegration) \
  (PotentialFitPartialCharges) \
  (PotentialParseAtomFragments) \
  (PotentialParseHomologies) \
  (PotentialParseParticleParameters) \
  (PotentialParsePotentials) \
  (PotentialSaveAtomFragments) \
  (PotentialSaveHomologies) \
  (PotentialSaveParticleParameters) \
  (PotentialSavePotentials) \
  (ParserSaveSelectedAtomsAsExtTypes) \
  (ParserSetParserParameters) \
  (ParserSetOutputFormats) \
  (ParserSetTremoloAtomdata) \
  (Undo) \
  (SelectionAllAtoms) \
  (SelectionAllAtomsInsideVolume) \
  (SelectionAllAtomsOfMolecule) \
  (SelectionAllMolecules) \
  (SelectionAllShapes) \
  (SelectionAtomByElement) \
  (SelectionAtomById) \
  (SelectionAtomByOrder) \
  (SelectionClearAllAtoms) \
  (SelectionClearAllMolecules) \
  (SelectionInvertAtoms) \
  (SelectionInvertMolecules) \
  (SelectionMoleculeOfAtom) \
  (SelectionMoleculeByFormula) \
  (SelectionMoleculeById) \
  (SelectionMoleculeByName) \
  (SelectionMoleculeByOrder) \
  (SelectionNotAllAtoms) \
  (SelectionNotAllAtomsInsideVolume) \
  (SelectionNotAllAtomsOfMolecule) \
  (SelectionNotAllMolecules) \
  (SelectionNotAllShapes) \
  (SelectionNotAtomById) \
  (SelectionNotAtomByElement) \
  (SelectionNotAtomByOrder) \
  (SelectionNotMoleculeOfAtom) \
  (SelectionNotMoleculeByFormula) \
  (SelectionNotMoleculeById) \
  (SelectionNotMoleculeByName) \
  (SelectionNotMoleculeByOrder) \
  (SelectionNotShapeByName) \
  (SelectionPopAtoms) \
  (SelectionPushAtoms) \
  (SelectionPopMolecules) \
  (SelectionPushMolecules) \
  (SelectionShapeByName) \
  (ShapeCombineShapes) \
  (ShapeCreateShape) \
  (ShapeRemoveShape) \
  (ShapeRotateShape) \
  (ShapeStretchShape) \
  (ShapeTranslateShape) \
  (TesselationConvexEnvelope) \
  (TesselationNonConvexEnvelope) \
  (WorldAddEmptyBoundary) \
  (WorldBoundInBox) \
  (WorldCenterInBox) \
  (WorldCenterOnEdge) \
  (WorldChangeBox) \
  (WorldInput) \
  (WorldOutput) \
  (WorldOutputAs) \
  (WorldRepeatBox) \
  (WorldScaleBox) \
  (WorldSetBoundaryConditions) \
  (WorldSetDefaultName) \
  (WorldSetWorldTime)

// extend list of actions in case levmar is available
#ifdef HAVE_LEVMAR
#define GLOBALLISTOFACTIONS_LEVMAR \
    BOOST_PP_SEQ_PUSH_BACK( \
    		BOOST_PP_SEQ_PUSH_BACK( \
    				GLOBALLISTOFACTIONS_initial, \
    				PotentialFitPotential \
    		), \
        PotentialFitCompoundPotential \
    )
#else
#define GLOBALLISTOFACTIONS_LEVMAR \
    GLOBALLISTOFACTIONS_initial
#endif /* HAVE_LEVMAR */

// define final list
#ifdef HAVE_PYTHON
#define GLOBALLISTOFACTIONS_PYTHON \
    BOOST_PP_SEQ_PUSH_BACK( \
        GLOBALLISTOFACTIONS_LEVMAR, \
        CommandLoadSession \
    )
#else
#define GLOBALLISTOFACTIONS_PYTHON \
    GLOBALLISTOFACTIONS_LEVMAR
#endif

#define GLOBALLISTOFACTIONS GLOBALLISTOFACTIONS_PYTHON

// define python list
// skips CommandLoadSession as this causes dangerous infinite loops
#define GLOBALLISTOFPYTHONACTIONS \
  GLOBALLISTOFACTIONS_LEVMAR

#endif /* GLOBALLISTOFACTIONS_HPP_ */

