/*
 * modules.hpp
 *
 *  Created on: Sep 28, 2013
 *      Author: heber
 */

#ifndef MODULES_HPP_
#define MODULES_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <vector>

#include "types.hpp"

namespace MoleCuilder {

namespace detail {

void module_exit();
void module_reinit();
bool module_wait();

typedef std::vector<atomId_t> atomIdVec;
typedef std::vector<atomicNumber_t> elementVec;
typedef std::vector<double> doubleVec;
typedef std::vector< std::vector<double> > atomPositionsVec;
typedef std::vector< std::string > stringVec;

doubleVec module_getBoundingBox();
double module_getDomainVolume();
int module_getSelectedAtomCount();
atomIdVec module_getSelectedAtomIds();
atomPositionsVec module_getSelectedAtomPositions();
elementVec module_getSelectedAtomElements();
double module_getSelectedMolarMass();

std::string module_getGraph6String();
std::string module_getElementListAsString();
MoleCuilder::detail::stringVec module_getAllGraph6Strings();
MoleCuilder::detail::stringVec module_getAllElementListAsStrings();

} /* namespace detail */

} /* namespace MoleCuilder */

#endif /* MODULES_HPP_ */
