/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * VectorCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "CommandLineUI/CommandLineDialog.hpp"

#include "Actions/Values.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Box.hpp"
#include "World.hpp"

CommandLineDialog::VectorCommandLineQuery::VectorCommandLineQuery(string title, bool _check, string _description) :
    Dialog::VectorQuery(title,_check, _description)
{}

CommandLineDialog::VectorCommandLineQuery::~VectorCommandLineQuery()
{}

bool CommandLineDialog::VectorCommandLineQuery::handle() {
  VectorValue temp;
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    temp = CommandLineParser::getInstance().vm[getTitle()].as< VectorValue >();
    tmp[0] = temp.x;
    tmp[1] = temp.y;
    tmp[2] = temp.z;
    if ((check) && (!World::getInstance().getDomain().isInside(tmp))) {
      DoeLog(1) && (eLog() << Verbose(1) << "Vector " << tmp << " would be outside of box domain." << endl);
      return false;
    }
    return true;
  } else {
    DoeLog(1) && (eLog() << Verbose(1) << "CommandLineUI parsing error: Missing vector for " << getTitle() << "." << endl);
    return false;
  }
}

