/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * DoublesCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "CommandLineUI/CommandLineDialog.hpp"

#include "CommandLineUI/CommandLineParser.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"

CommandLineDialog::DoublesCommandLineQuery::DoublesCommandLineQuery(string title, string _description) :
    Dialog::DoublesQuery(title, _description)
{}

CommandLineDialog::DoublesCommandLineQuery::~DoublesCommandLineQuery() {}

bool CommandLineDialog::DoublesCommandLineQuery::handle() {
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    tmp = CommandLineParser::getInstance().vm[getTitle()].as< std::vector<double> >();
    return true;
  } else {
    DoeLog(1) && (eLog() << Verbose(1) << "CommandLineUI parsing error: Missing doubles for " << getTitle() << "." << endl);
    return false;
  }
}

