/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * BoundInBoxAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <boost/shared_ptr.hpp>

#include "CodePatterns/Log.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <iostream>
#include <string>
#include <vector>

#include "Actions/WorldAction/BoundInBoxAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "BoundInBoxAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr WorldBoundInBoxAction::performCall() {
  // create undo state
  std::vector< boost::shared_ptr<Vector> > OldPositions;
  std::vector<molecule*> AllMolecules = World::getInstance().getAllMolecules();
  for (vector<molecule*>::iterator MolRunner = AllMolecules.begin();
      MolRunner != AllMolecules.end();
      ++MolRunner) {
    for(molecule::const_iterator AtomRunner = (*MolRunner)->begin();
        AtomRunner != (*MolRunner)->end();
        ++AtomRunner) {
      OldPositions.push_back(
          boost::shared_ptr<Vector>(new Vector(
              (*AtomRunner)->getPosition()
              ))
          );
    }
  }
  WorldBoundInBoxState *undoState = new WorldBoundInBoxState(OldPositions, params);

  // center
  for (std::vector<molecule*>::iterator MolRunner = AllMolecules.begin(); MolRunner != AllMolecules.end(); ++MolRunner) {
    (*MolRunner)->BoundInBox();
  }
  return Action::state_ptr(undoState);
}

Action::state_ptr WorldBoundInBoxAction::performUndo(Action::state_ptr _state) {
  WorldBoundInBoxState *state = assert_cast<WorldBoundInBoxState*>(_state.get());

  // place atoms on old positions
  std::vector< boost::shared_ptr<Vector> >::const_iterator OldPositionsIter = state->OldPositions.begin();
  std::vector<molecule*> AllMolecules = World::getInstance().getAllMolecules();
  for (std::vector<molecule*>::iterator MolRunner = AllMolecules.begin();
      MolRunner != AllMolecules.end();
      ++MolRunner) {
    for(molecule::iterator AtomRunner = (*MolRunner)->begin();
        AtomRunner != (*MolRunner)->end();
        ++AtomRunner) {
      ASSERT(OldPositionsIter != state->OldPositions.end(),
          "WorldBoundInBoxAction::performUndo() - too few positions stored in UndoState.");
      (*AtomRunner)->setPosition(**(OldPositionsIter++));
    }
  }

  return Action::state_ptr(_state);
}

Action::state_ptr WorldBoundInBoxAction::performRedo(Action::state_ptr _state){
//  WorldBoundInBoxState *state = assert_cast<WorldBoundInBoxState*>(_state.get());

  // center
  std::vector<molecule*> AllMolecules = World::getInstance().getAllMolecules();
  for (std::vector<molecule*>::iterator MolRunner = AllMolecules.begin();
      MolRunner != AllMolecules.end();
      ++MolRunner) {
    (*MolRunner)->BoundInBox();
  }

  return Action::state_ptr(_state);
}

bool WorldBoundInBoxAction::canUndo() {
  return true;
}

bool WorldBoundInBoxAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
