/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2014 Frederik Heber. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SphericalPointDistribution_getPoints.cpp
 *
 *  Created on: Jul 12, 2014
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "SphericalPointDistribution.hpp"

#include "CodePatterns/Assert.hpp"

#include "LinearAlgebra/Vector.hpp"

template <>
SphericalPointDistribution::Polygon_t SphericalPointDistribution::get<0>() const
{
  Polygon_t polygon;
  ASSERT( polygon.size() == 0,
      "SphericalPointDistribution::get<0>() - polygon has wrong size.");
  return polygon;
}

template <>
SphericalPointDistribution::Polygon_t SphericalPointDistribution::get<1>() const
{
  Polygon_t polygon;
  polygon.push_back( Vector(Bondlength,0.,0.));
  ASSERT( polygon.size() == 1,
      "SphericalPointDistribution::get<1>() - polygon has wrong size.");
  return polygon;
}

template <>
SphericalPointDistribution::Polygon_t SphericalPointDistribution::get<2>() const
{
  Polygon_t polygon;
  polygon.push_back( Vector(Bondlength,0.,0.));
  polygon.push_back( Vector(-Bondlength,0.,0.));
  ASSERT( polygon.size() == 2,
      "SphericalPointDistribution::get<2>() - polygon has wrong size.");
  return polygon;
}

template <>
SphericalPointDistribution::Polygon_t SphericalPointDistribution::get<3>() const
{
  Polygon_t polygon;
  polygon.push_back( Vector(Bondlength,0.,0.));
  polygon.push_back( Vector(-Bondlength*0.5, SQRT_3*0.5,0.));
  polygon.push_back( Vector(-Bondlength*0.5, -SQRT_3*0.5,0.));
  ASSERT( polygon.size() == 3,
      "SphericalPointDistribution::get<3>() - polygon has wrong size.");
  return polygon;
}

template <>
SphericalPointDistribution::Polygon_t SphericalPointDistribution::get<4>() const
{
  Polygon_t polygon;
  polygon.push_back( Vector(Bondlength,0.,0.));
  polygon.push_back( Vector(-Bondlength/3.0, Bondlength*2.0*M_SQRT2/3.0,0.));
  polygon.push_back( Vector(-Bondlength/3.0, -Bondlength*M_SQRT2/3.0, Bondlength*M_SQRT2/SQRT_3));
  polygon.push_back( Vector(-Bondlength/3.0, -Bondlength*M_SQRT2/3.0, -Bondlength*M_SQRT2/SQRT_3));
  ASSERT( polygon.size() == 4,
      "SphericalPointDistribution::get<4>() - polygon has wrong size.");
  return polygon;
}

template <>
SphericalPointDistribution::Polygon_t SphericalPointDistribution::get<5>() const
{
  Polygon_t polygon;
  polygon.push_back( Vector(Bondlength,0.,0.));
  polygon.push_back( Vector(-Bondlength, 0.0, 0.0));
  polygon.push_back( Vector(0.0, Bondlength, 0.0));
  polygon.push_back( Vector(0.0, -Bondlength*0.5, Bondlength*SQRT_3*0.5));
  polygon.push_back( Vector(0.0, -Bondlength*0.5, -Bondlength*SQRT_3*0.5));
  ASSERT( polygon.size() == 5,
      "SphericalPointDistribution::get<5>() - polygon has wrong size.");
  return polygon;
}

template <>
SphericalPointDistribution::Polygon_t SphericalPointDistribution::get<6>() const
{
  Polygon_t polygon;
  polygon.push_back( Vector(Bondlength,0.,0.));
  polygon.push_back( Vector(-Bondlength, 0.0, 0.0));
  polygon.push_back( Vector(0.0, Bondlength, 0.0));
  polygon.push_back( Vector(0.0, -Bondlength, 0.0));
  polygon.push_back( Vector(0.0, 0.0, Bondlength));
  polygon.push_back( Vector(0.0, 0.0, -Bondlength));
  ASSERT( polygon.size() == 6,
      "SphericalPointDistribution::get<6>() - polygon has wrong size.");
  return polygon;
}

template <>
SphericalPointDistribution::Polygon_t SphericalPointDistribution::get<7>() const
{
  Polygon_t polygon;
  polygon.push_back( Vector(Bondlength,0.,0.));
  polygon.push_back( Vector(-Bondlength, 0.0, 0.0));
  polygon.push_back( Vector(0.0, Bondlength, 0.0));
  polygon.push_back( Vector(0.0, Bondlength*cos(M_PI*0.4), Bondlength*sin(M_PI*0.4)));
  polygon.push_back( Vector(0.0, Bondlength*cos(M_PI*0.8), Bondlength*sin(M_PI*0.8)));
  polygon.push_back( Vector(0.0, Bondlength*cos(M_PI*1.2), Bondlength*sin(M_PI*1.2)));
  polygon.push_back( Vector(0.0, Bondlength*cos(M_PI*1.6), Bondlength*sin(M_PI*1.6)));
  ASSERT( polygon.size() == 7,
      "SphericalPointDistribution::get<7>() - polygon has wrong size.");
  return polygon;
}

template <>
SphericalPointDistribution::Polygon_t SphericalPointDistribution::get<8>() const
{
  Polygon_t polygon;
  polygon.push_back( Vector(Bondlength,0.,0.));
  polygon.push_back( Vector(-Bondlength, 0.0, 0.0));
  polygon.push_back( Vector(-Bondlength/3.0, Bondlength*2.0*M_SQRT2/3.0, 0.0));
  polygon.push_back( Vector(-Bondlength/3.0, -Bondlength*M_SQRT2/3.0, Bondlength*M_SQRT2/SQRT_3));
  polygon.push_back( Vector(-Bondlength/3.0, -Bondlength*M_SQRT2/3.0, -Bondlength*M_SQRT2/SQRT_3));
  polygon.push_back( Vector(Bondlength/3.0, -Bondlength*2.0*M_SQRT2/3.0, 0.0));
  polygon.push_back( Vector(Bondlength/3.0, Bondlength*M_SQRT2/3.0, -Bondlength*M_SQRT2/SQRT_3));
  polygon.push_back( Vector(Bondlength/3.0, Bondlength*M_SQRT2/3.0, Bondlength*M_SQRT2/SQRT_3));
  ASSERT( polygon.size() == 8,
      "SphericalPointDistribution::get<8>() - polygon has wrong size.");
  return polygon;
}

template <>
SphericalPointDistribution::Polygon_t SphericalPointDistribution::get<9>() const
{
  Polygon_t polygon;
  polygon.push_back( Vector(Bondlength,0.,0.));
  polygon.push_back( Vector(Bondlength*cos(0.4*M_PI), Bondlength*sin(0.4*M_PI), 0.0));
  polygon.push_back( Vector(Bondlength*cos(0.4*M_PI), -Bondlength*sin(0.4*M_PI), 0.0));
  polygon.push_back( Vector(Bondlength*cos(0.4*M_PI), 0.0, Bondlength*sin(0.4*M_PI)));
  polygon.push_back( Vector(Bondlength*cos(0.4*M_PI), 0.0, -Bondlength*sin(0.4*M_PI)));
  polygon.push_back( Vector(Bondlength*cos(0.8*M_PI), Bondlength*sin(0.8*M_PI)*sin(0.25*M_PI), Bondlength*sin(0.8*M_PI)*cos(0.25*M_PI)));
  polygon.push_back( Vector(Bondlength*cos(0.8*M_PI), Bondlength*sin(0.8*M_PI)*sin(0.75*M_PI), Bondlength*sin(0.8*M_PI)*cos(0.75*M_PI)));
  polygon.push_back( Vector(Bondlength*cos(0.8*M_PI), Bondlength*sin(0.8*M_PI)*sin(1.25*M_PI), Bondlength*sin(0.8*M_PI)*cos(1.25*M_PI)));
  polygon.push_back( Vector(Bondlength*cos(0.8*M_PI), Bondlength*sin(0.8*M_PI)*sin(1.75*M_PI), Bondlength*sin(0.8*M_PI)*cos(1.75*M_PI)));
  ASSERT( polygon.size() == 9,
      "SphericalPointDistribution::get<9>() - polygon has wrong size.");
  return polygon;
}

template <>
SphericalPointDistribution::Polygon_t SphericalPointDistribution::get<10>() const
{
  Polygon_t polygon;
  polygon.push_back( Vector(Bondlength,0.,0.));
  polygon.push_back( Vector(-Bondlength, 0.0, 0.0));
  const double temp_Bondlength = Bondlength*0.5*SQRT_3;
  polygon.push_back( Vector(temp_Bondlength/SQRT_3, temp_Bondlength, 0.0));
  polygon.push_back( Vector(temp_Bondlength/SQRT_3, -temp_Bondlength, 0.0));
  polygon.push_back( Vector(temp_Bondlength/SQRT_3, 0.0, temp_Bondlength));
  polygon.push_back( Vector(temp_Bondlength/SQRT_3, 0.0, -temp_Bondlength));
  polygon.push_back( Vector(-temp_Bondlength/SQRT_3, temp_Bondlength*sin(0.25*M_PI), temp_Bondlength*cos(0.25*M_PI)));
  polygon.push_back( Vector(-temp_Bondlength/SQRT_3, temp_Bondlength*sin(0.75*M_PI), temp_Bondlength*cos(0.75*M_PI)));
  polygon.push_back( Vector(-temp_Bondlength/SQRT_3, temp_Bondlength*sin(1.25*M_PI), temp_Bondlength*cos(1.25*M_PI)));
  polygon.push_back( Vector(-temp_Bondlength/SQRT_3, temp_Bondlength*sin(1.75*M_PI), temp_Bondlength*cos(1.75*M_PI)));
  ASSERT( polygon.size() == 10,
      "SphericalPointDistribution::get<10>() - polygon has wrong size.");
  return polygon;
}

template <>
SphericalPointDistribution::Polygon_t SphericalPointDistribution::get<11>() const
{
  Polygon_t polygon;
  polygon.push_back( Vector(Bondlength,0.,0.));
  {
    const double temp_Bondlength = Bondlength*sin(0.4*M_PI);
    polygon.push_back( Vector(Bondlength*cos(0.4*M_PI), temp_Bondlength, 0.0));
    polygon.push_back( Vector(Bondlength*cos(0.4*M_PI), temp_Bondlength*cos(0.4*M_PI),  temp_Bondlength*sin(0.4*M_PI)));
    polygon.push_back( Vector(Bondlength*cos(0.4*M_PI), temp_Bondlength*cos(0.8*M_PI),  temp_Bondlength*sin(0.8*M_PI)));
    polygon.push_back( Vector(Bondlength*cos(0.4*M_PI), temp_Bondlength*cos(1.2*M_PI),  temp_Bondlength*sin(1.2*M_PI)));
    polygon.push_back( Vector(Bondlength*cos(0.4*M_PI), temp_Bondlength*cos(1.6*M_PI),  temp_Bondlength*sin(1.6*M_PI)));
  }
  {
    const double temp_Bondlength = Bondlength*sin(0.8*M_PI);
    polygon.push_back( Vector(Bondlength*cos(0.8*M_PI), temp_Bondlength*cos(0.2*M_PI),  temp_Bondlength*sin(0.2*M_PI)));
    polygon.push_back( Vector(Bondlength*cos(0.8*M_PI), temp_Bondlength*cos(0.6*M_PI),  temp_Bondlength*sin(0.6*M_PI)));
    polygon.push_back( Vector(Bondlength*cos(0.8*M_PI), temp_Bondlength*cos(1.0*M_PI),  temp_Bondlength*sin(1.0*M_PI)));
    polygon.push_back( Vector(Bondlength*cos(0.8*M_PI), temp_Bondlength*cos(1.4*M_PI),  temp_Bondlength*sin(1.4*M_PI)));
    polygon.push_back( Vector(Bondlength*cos(0.8*M_PI), temp_Bondlength*cos(1.8*M_PI),  temp_Bondlength*sin(1.8*M_PI)));
  }
  ASSERT( polygon.size() == 11,
      "SphericalPointDistribution::get<11>() - polygon has wrong size.");
  return polygon;
}

template <>
SphericalPointDistribution::Polygon_t SphericalPointDistribution::get<12>() const
{
  Polygon_t polygon;
  polygon.push_back( Vector(Bondlength,0.,0.));
  polygon.push_back( Vector(-Bondlength, 0.0, 0.0));
  const double temp_Bondlength = Bondlength*0.5*SQRT_3;
  polygon.push_back( Vector(temp_Bondlength/SQRT_3, temp_Bondlength, 0.0));
  polygon.push_back( Vector(temp_Bondlength/SQRT_3, temp_Bondlength*cos(0.4*M_PI),  temp_Bondlength*sin(0.4*M_PI)));
  polygon.push_back( Vector(temp_Bondlength/SQRT_3, temp_Bondlength*cos(0.8*M_PI),  temp_Bondlength*sin(0.8*M_PI)));
  polygon.push_back( Vector(temp_Bondlength/SQRT_3, temp_Bondlength*cos(1.2*M_PI),  temp_Bondlength*sin(1.2*M_PI)));
  polygon.push_back( Vector(temp_Bondlength/SQRT_3, temp_Bondlength*cos(1.6*M_PI),  temp_Bondlength*sin(1.6*M_PI)));
  polygon.push_back( Vector(-temp_Bondlength/SQRT_3, -temp_Bondlength, 0.0));
  polygon.push_back( Vector(-temp_Bondlength/SQRT_3, -temp_Bondlength*cos(0.4*M_PI),  -temp_Bondlength*sin(0.4*M_PI)));
  polygon.push_back( Vector(-temp_Bondlength/SQRT_3, -temp_Bondlength*cos(0.8*M_PI),  -temp_Bondlength*sin(0.8*M_PI)));
  polygon.push_back( Vector(-temp_Bondlength/SQRT_3, -temp_Bondlength*cos(1.2*M_PI),  -temp_Bondlength*sin(1.2*M_PI)));
  polygon.push_back( Vector(-temp_Bondlength/SQRT_3, -temp_Bondlength*cos(1.6*M_PI),  -temp_Bondlength*sin(1.6*M_PI)));
  ASSERT( polygon.size() == 12,
      "SphericalPointDistribution::get<12>() - polygon has wrong size.");
  return polygon;
}

template <>
SphericalPointDistribution::Polygon_t SphericalPointDistribution::get<14>() const
{
  Polygon_t polygon;
  polygon.push_back( Vector(Bondlength,0.,0.));
  polygon.push_back( Vector(-Bondlength, 0.0, 0.0));
  const double temp_Bondlength = Bondlength*0.5*SQRT_3;
  polygon.push_back( Vector(temp_Bondlength/SQRT_3, temp_Bondlength, 0.0));
  polygon.push_back( Vector(temp_Bondlength/SQRT_3, temp_Bondlength*cos(M_PI/3.0), temp_Bondlength*sin(M_PI/3.0)));
  polygon.push_back( Vector(temp_Bondlength/SQRT_3, temp_Bondlength*cos(2.0*M_PI/3.0), temp_Bondlength*sin(2.0*M_PI/3.0)));
  polygon.push_back( Vector(temp_Bondlength/SQRT_3, -temp_Bondlength, 0.0));
  polygon.push_back( Vector(temp_Bondlength/SQRT_3, temp_Bondlength*cos(4.0*M_PI/3.0), temp_Bondlength*sin(4.0*M_PI/3.0)));
  polygon.push_back( Vector(temp_Bondlength/SQRT_3, temp_Bondlength*cos(5.0*M_PI/3.0), temp_Bondlength*sin(5.0*M_PI/3.0)));
  polygon.push_back( Vector(-temp_Bondlength/SQRT_3, temp_Bondlength*cos(M_PI/6.0),  temp_Bondlength*sin(M_PI/6.0)));
  polygon.push_back( Vector(-temp_Bondlength/SQRT_3, temp_Bondlength*cos(M_PI/3.0 +M_PI/6.0),  temp_Bondlength*sin(M_PI/3.0+M_PI/6.0)));
  polygon.push_back( Vector(-temp_Bondlength/SQRT_3, temp_Bondlength*cos(2.0*M_PI/3.0 +M_PI/6.0),  temp_Bondlength*sin(2.0*M_PI/3.0 +M_PI/6.0)));
  polygon.push_back( Vector(-temp_Bondlength/SQRT_3, temp_Bondlength*cos(3.0*M_PI/3.0 +M_PI/6.0),  temp_Bondlength*sin(3.0*M_PI/3.0 +M_PI/6.0)));
  polygon.push_back( Vector(-temp_Bondlength/SQRT_3, temp_Bondlength*cos(4.0*M_PI/3.0 +M_PI/6.0),  temp_Bondlength*sin(4.0*M_PI/3.0 +M_PI/6.0)));
  polygon.push_back( Vector(-temp_Bondlength/SQRT_3, temp_Bondlength*cos(5.0*M_PI/3.0 +M_PI/6.0),  temp_Bondlength*sin(5.0*M_PI/3.0 +M_PI/6.0)));
  ASSERT( polygon.size() == 14,
      "SphericalPointDistribution::get<14>() - polygon has wrong size.");
  return polygon;
}

