/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * VMGJob.cpp
 *
 *  Created on: Jul 13, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include headers that implement a archive in simple text format
// otherwise BOOST_CLASS_EXPORT_IMPLEMENT has no effect
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include "CodePatterns/MemDebug.hpp"

#include "Jobs/VMGJob.hpp"

#include "grid/tempgrid.hpp"

VMGJob::VMGJob(const JobId_t _JobId, const std::vector< double > &_sampled_input) :
  FragmentJob(_JobId),
  sampled_input(_sampled_input)
{}

VMGJob::VMGJob() :
  FragmentJob(JobId::IllegalJob)
{}

VMGJob::~VMGJob()
{}

FragmentResult::ptr VMGJob::Work()
{
  VMG::TempGrid *grid = new VMG::TempGrid();
  FragmentResult::ptr ptr( new FragmentResult(getId()) );
  delete grid;
  return ptr;
}

// we need to explicitly instantiate the serialization functions as
// its is only serialized through its base class FragmentJob
BOOST_CLASS_EXPORT_IMPLEMENT(VMGJob)
