/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ElementCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <string>

#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Element/element.hpp"
#include "Element/periodentafel.hpp"
#include "World.hpp"

CommandLineDialog::ElementCommandLineQuery::ElementCommandLineQuery(Parameter<const element*> &_param, const std::string &_title, const std::string &_description) :
    Dialog::TQuery<const element *>(_param, _title, _description)
{}

CommandLineDialog::ElementCommandLineQuery::~ElementCommandLineQuery()
{}

bool CommandLineDialog::ElementCommandLineQuery::handle() {
  // TODO: vector of ints and removing first is not correctly implemented yet. How to remove from a vector?
  periodentafel *periode = World::getInstance().getPeriode();
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    std::string argument("none");
    try {
      argument = CommandLineParser::getInstance().vm[getTitle()].as< std::string >();
      try {
        int Z = -1;
        Z = boost::lexical_cast<int>(argument);
        temp = periode->FindElement(Z);
      } catch(boost::bad_lexical_cast &e) {
        temp = periode->FindElement(argument);
      }
    } catch(boost::bad_any_cast &e) {
      return false;
    }
    ASSERT(temp != NULL, "Invalid element specified in ElementCommandLineQuery");
    return true;
  }
  return false;
}

