/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ParserXmlUnitTest.cpp
 *
 *  Created on: Mar 24, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ParserXmlUnitTest.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "World.hpp"
#include "Atom/atom.hpp"
#include "Element/element.hpp"
#include "Element/periodentafel.hpp"
#include "CodePatterns/Log.hpp"
#include "Descriptors/AtomTypeDescriptor.hpp"
#include "Parser/ChangeTracker.hpp"
#include "Parser/XmlParser.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

using namespace std;

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ParserXmlUnitTest );

static string waterXml = "\
<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\
<!DOCTYPE scafacos_test SYSTEM 'scafacos_test.dtd'>\n\
\t<scafacos_test name=\"cloud-wall\" description=\"A 3D-periodic system of two walls charges and a random cloud of charges.\" reference_method=\"ewald\" error_potential=\"1.0e-13\" error_field=\"1.0e-13\">\n\
\t\t<configuration offset=\"0 0 0\" box_a=\"10 0 0\" box_b=\"0 10 0\" box_c=\"0 0 10\" periodicity=\"1 1 1\" epsilon=\"metallic\">\n\
\t\t\t<particle position=\"0 0 4.5\" q=\"1\" potential=\"1.318858869367693\" field=\"0.27973426575304 -0.1382533033408908 5.200985873286221\"/>\n\
\t\t\t<particle position=\"0 0 5.5\" q=\"1\" potential=\"1.318858869367693\" field=\"0.27973426575304 -0.1382533033408908 5.200985873286221\"/>\n\
\t\t\t<particle position=\"0 0 6.5\" q=\"1\" potential=\"1.318858869367693\" field=\"0.27973426575304 -0.1382533033408908 5.200985873286221\"/>\n\
\t\t</configuration>\n\
\t</scafacos_test>\n";
static string waterMultiXml = "\n";

void ParserXmlUnitTest::setUp() {
  World::getInstance();

  parser = new FormatParser<xml>();

  setVerbosity(2);

  // we need hydrogens and oxygens in the following tests
  CPPUNIT_ASSERT(World::getInstance().getPeriode()->FindElement(1) != NULL);
  CPPUNIT_ASSERT(World::getInstance().getPeriode()->FindElement(8) != NULL);
}

void ParserXmlUnitTest::tearDown()
{
  delete parser;
  ChangeTracker::purgeInstance();
  World::purgeInstance();
}

/************************************ tests ***********************************/

void ParserXmlUnitTest::readwriteXmlTest() {
  cout << "Testing the XML parser." << endl;
  stringstream input;
  input << waterXml;
  parser->load(&input);
  input.clear();

  CPPUNIT_ASSERT_EQUAL(3, World::getInstance().numAtoms());

  // store and parse in again
  {
//    std::string first;
//    std::string second;
    std::stringstream output;
    std::vector<atom *> atoms = World::getInstance().getAllAtoms();
    parser->save(&output, atoms);
    std::cout << output.str();

    {
      delete parser;
      parser = new FormatParser<xml>();
      std::stringstream input(waterXml);
      parser->load(&input);
    }

    FormatParser<xml> *parser_control = new FormatParser<xml>();
    parser_control->load(&output);
    CPPUNIT_ASSERT( parser->data == parser_control->data );
    delete parser_control;
//    // check for non-empty streams
//    input.peek();
//    output.peek();
//    CPPUNIT_ASSERT(input.good() && output.good());
//    // check equality of streams per line (for debugging)
//    for (; std::getline(input, first) && std::getline(output, second); ) {
//      std::cout << "Comparing '" << first << "' to '" << second << "'" << std::endl;
//      CPPUNIT_ASSERT(first == second);
//    }
  }
}
