/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ParameterStorageUnitTest.cpp
 *
 *  Created on: Sep 30, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "ParameterStorageUnitTest.hpp"

#include <typeinfo>

#include "Parser/Parameters/ParameterStorage.hpp"
#include "Parser/Parameters/ContinuousParameter.hpp"
#include "Parser/Parameters/DiscreteParameter.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ParameterStorageTest );


void ParameterStorageTest::setUp()
{}


void ParameterStorageTest::tearDown()
{}

void ParameterStorageTest::instanceTest()
{
  std::vector<int> ValidValues;
  for( int i=1; i<=4; ++i)
    ValidValues.push_back(i);
  range<double> ValidRange(1., 4.);
  Parameter *intParam = new DiscreteParameter<int>("intParam", ValidValues);
  Parameter *doubleParam = new ContinuousParameter<double>("doubleParam", ValidRange);
  // note: delete is done by registry in tearDown ...

  // check that both are not present
  CPPUNIT_ASSERT_EQUAL(false, storage.isPresentByName("intParam"));
  CPPUNIT_ASSERT_EQUAL(false, storage.isPresentByName("doubleParam"));
  storage.registerInstance(intParam);
  storage.registerInstance(doubleParam);
  CPPUNIT_ASSERT_EQUAL(true, storage.isPresentByName("intParam"));
  CPPUNIT_ASSERT_EQUAL(true, storage.isPresentByName("doubleParam"));

  // retrieve instances and check address
  CPPUNIT_ASSERT_EQUAL(intParam, storage.getByName("intParam"));
  CPPUNIT_ASSERT_EQUAL(doubleParam, storage.getByName("doubleParam"));
}
