/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculeByIdAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "molecule.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Descriptors/MoleculeIdDescriptor.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "MoleculeByIdAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "MoleculeByIdAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionMoleculeByIdAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  const molecule *mol = World::getInstance().getMolecule(MoleculeById(params.molindex));
  if (mol != NULL) {
    if (!World::getInstance().isSelected(mol)) {
      DoLog(1) && (Log() << Verbose(1) << "Selecting molecule " << mol->name << endl);
      World::getInstance().selectAllMolecules(MoleculeById(params.molindex));
      DoLog(0) && (Log() << Verbose(0) << World::getInstance().countSelectedMolecules() << " molecules selected." << endl);
      return Action::state_ptr(new SelectionMoleculeByIdState(params));
    } else {
      return Action::success;
    }
  } else {
    return Action::failure;
  }
}

Action::state_ptr SelectionMoleculeByIdAction::performUndo(Action::state_ptr _state) {
  SelectionMoleculeByIdState *state = assert_cast<SelectionMoleculeByIdState*>(_state.get());

  World::getInstance().unselectAllMolecules(MoleculeById(state->params.molindex));

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionMoleculeByIdAction::performRedo(Action::state_ptr _state){
  SelectionMoleculeByIdState *state = assert_cast<SelectionMoleculeByIdState*>(_state.get());

  World::getInstance().selectAllMolecules(MoleculeById(state->params.molindex));

  return Action::state_ptr(_state);
}

bool SelectionMoleculeByIdAction::canUndo() {
  return true;
}

bool SelectionMoleculeByIdAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
