/*
 * CustomException.hpp
 *
 *  Created on: Apr 7, 2010
 *      Author: crueger
 */

#ifndef CUSTOMEXCEPTION_HPP_
#define CUSTOMEXCEPTION_HPP_

#include <exception>
#include <iostream>

/**
 * Custom Exceptions are simply a bit more verbose versions of the
 * std::exceptions.
 */
class CustomException : public std::exception
{
  friend std::ostream& operator<<(std::ostream &ost, CustomException &excp);
public:
  CustomException(std::string file, int line);
  virtual ~CustomException() throw();

private:
  std::string file;
  int line;
};

std::ostream& operator<<(std::ostream &ost, CustomException &excp);

#endif /* CUSTOMEXCEPTION_HPP_ */
