/*
 * InterfaceVMGJob.hpp
 *
 *  Created on: 10.06.2012
 *      Author: Frederik Heber
 */

#ifndef INTERFACEVMGJOB_HPP_
#define INTERFACEVMGJOB_HPP_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/function.hpp>

#include "base/interface.hpp"
#include "base/vector.hpp"
#include "units/particle/bspline.hpp"
#include "units/particle/particle.hpp"

namespace VMG
{
class MGGrid;
class MGMultigrid;
}

namespace VMGInterfaces
{

class InterfaceVMGJob : public VMG::Interface
{
public:
  InterfaceVMGJob(const std::vector< double > &_sampled_input,
      std::vector< double > &_sampled_output,
      const std::vector< std::vector< double > > &_particle_positions,
      const std::vector< double > &_particle_charges,
      VMG::Boundary boundary,
      int levelMin,
      int levelMax,
      const VMG::Vector &box_begin,
      vmg_float box_end,
      const int& near_field_cells,
      int coarseningSteps=0,
      double alpha=1.6);

  virtual ~InterfaceVMGJob();

  void ImportRightHandSide(VMG::Multigrid& multigrid);
  void ExportSolution(VMG::Grid& grid);

protected:
  VMG::Particle::BSpline spl;

private:
  //!> sampled density on the grid as input
  const std::vector< double > sampled_input;
  //!> sampled potential on the grid as output
  std::vector< double > &sampled_output;
  //!> number of grid points per axis as \f$2^{\text{level}}\f$
  const int level;
  //!> nuclei charges
  std::list<VMG::Particle::Particle> particles;
};

}

#endif /* INTERFACEVMGJOB_HPP_ */
