/*
 * WorldIterators.cpp
 *
 *  Created on: Feb 25, 2010
 *      Author: crueger
 */

#include "Descriptors/AtomDescriptor.hpp"
#include "Descriptors/AtomDescriptor_impl.hpp"
#include "Descriptors/MoleculeDescriptor.hpp"
#include "Descriptors/MoleculeDescriptor_impl.hpp"
#include "atom.hpp"
#include "molecule.hpp"
#include "World.hpp"

/********************** Atoms *************************/

World::AtomIterator::AtomIterator(){
  state = World::getInstance().atomEnd();
}

World::AtomIterator::AtomIterator(AtomDescriptor _descr, World* _world) :
    descr(_descr.get_impl()),
    index(0),
    world(_world)
{
  state = world->atoms.begin();
  advanceState();
}

World::AtomIterator::AtomIterator(const AtomIterator& rhs) :
    state(rhs.state),
    descr(rhs.descr),
    index(rhs.index),
    world(rhs.world)
  {}

World::AtomIterator& World::AtomIterator::operator=(const AtomIterator& rhs)
{
  if(&rhs!=this){
    state=rhs.state;
    descr=rhs.descr;
    index=rhs.index;
    world=rhs.world;
  }
  return *this;
}

World::AtomIterator& World::AtomIterator::operator++(){
  ++state;
  ++index;
  advanceState();
  return *this;
}

World::AtomIterator World::AtomIterator::operator++(int){
  AtomIterator res(*this);
  ++(*this);
  return res;
}

bool World::AtomIterator::operator==(const AtomIterator& rhs){
  return state==rhs.state;
}

bool World::AtomIterator::operator==(const World::AtomSet::iterator& rhs){
  return state==rhs;
}

bool World::AtomIterator::operator!=(const AtomIterator& rhs){
  return state!=rhs.state;
}

bool World::AtomIterator::operator!=(const World::AtomSet::iterator& rhs){
  return state!=rhs;
}

atom* World::AtomIterator::operator*(){
  return (*state).second;
}

void World::AtomIterator::advanceState(){
  // go forward until we have a matching atom or the end is reached
  while((state!=world->atoms.end()) && (!descr->predicate(*state))){
    ++state;
    ++index;
  }
}

int World::AtomIterator::getCount(){
  return index;
}

/*********************************** Molecules ************************/

World::MoleculeIterator::MoleculeIterator(){
  state = World::getInstance().moleculeEnd();
}

World::MoleculeIterator::MoleculeIterator(MoleculeDescriptor _descr, World* _world) :
    descr(_descr.get_impl()),
    index(0),
    world(_world)
{
  state = world->molecules.begin();
  advanceState();
}

World::MoleculeIterator::MoleculeIterator(const MoleculeIterator& rhs) :
    state(rhs.state),
    descr(rhs.descr),
    index(rhs.index),
    world(rhs.world)
  {}

World::MoleculeIterator& World::MoleculeIterator::operator=(const MoleculeIterator& rhs)
{
  if(&rhs!=this){
    state=rhs.state;
    descr=rhs.descr;
    index=rhs.index;
    world=rhs.world;
  }
  return *this;
}

World::MoleculeIterator& World::MoleculeIterator::operator++(){
  ++state;
  ++index;
  advanceState();
  return *this;
}

World::MoleculeIterator World::MoleculeIterator::operator++(int){
  MoleculeIterator res(*this);
  ++(*this);
  return res;
}

bool World::MoleculeIterator::operator==(const MoleculeIterator& rhs){
  return state==rhs.state;
}

bool World::MoleculeIterator::operator==(const World::MoleculeSet::iterator& rhs){
  return state==rhs;
}

bool World::MoleculeIterator::operator!=(const MoleculeIterator& rhs){
  return state!=rhs.state;
}

bool World::MoleculeIterator::operator!=(const World::MoleculeSet::iterator& rhs){
  return state!=rhs;
}

molecule* World::MoleculeIterator::operator*(){
  return (*state).second;
}

void World::MoleculeIterator::advanceState(){
  while((state!=world->molecules.end()) && (!descr->predicate(*state))){
    ++state;
    ++index;
  }
}

int World::MoleculeIterator::getCount(){
  return index;
}

