/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * BoxCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Actions/Values.hpp"
#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"

CommandLineDialog::RealSpaceMatrixCommandLineQuery::RealSpaceMatrixCommandLineQuery(Parameter<RealSpaceMatrix> &_param, const std::string &_title, const std::string &_description) :
    Dialog::TQuery<RealSpaceMatrix>(_param, _title, _description)
{}

CommandLineDialog::RealSpaceMatrixCommandLineQuery::~RealSpaceMatrixCommandLineQuery()
{}

bool CommandLineDialog::RealSpaceMatrixCommandLineQuery::handle() {
  RealSpaceMatrixValue _temp;
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    try {
      _temp = CommandLineParser::getInstance().vm[getTitle()].as< RealSpaceMatrixValue >();
    } catch(boost::bad_any_cast &e) {
      for (size_t i=0;i<(NDIM*(NDIM+1))/2;++i)
        _temp.matrix[i] = 0.;
      return false;
    }
    temp = _temp.toRealSpaceMatrix();
    return true;
  }
  return false;
}

