/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * IntCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

CommandLineDialog::IntCommandLineQuery::IntCommandLineQuery(Parameter<int> &_param, const std::string &_title, const std::string &_description) :
    Dialog::TQuery<int>(_param, _title, _description)
{}

CommandLineDialog::IntCommandLineQuery::~IntCommandLineQuery() {}

bool CommandLineDialog::IntCommandLineQuery::handle() {
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    try {
      temp = CommandLineParser::getInstance().vm[getTitle()].as<int>();
    } catch(boost::bad_any_cast &e) {
      temp = 0;
      return false;
    }
    return true;
  }
  return false;
}

