/*
 * SamplingGrid_inline.hpp
 *
 *  Created on: Jan 27, 2013
 *      Author: heber
 */

#ifndef SAMPLINGGRID_INLINE_HPP_
#define SAMPLINGGRID_INLINE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "SamplingGrid.hpp"

#ifdef HAVE_INLINE
inline
#endif
const double SamplingGrid::getWindowVolume() const
{
  double volume = 1.;
  for (size_t i=0;i<NDIM;++i)
    volume *= end_window[i]-begin_window[i];
  return volume;
}

#ifdef HAVE_INLINE
inline
#endif
const double SamplingGrid::getWindowLengthPerAxis(const size_t axis) const
{
  return (end_window[axis] - begin_window[axis]);
}

#ifdef HAVE_INLINE
inline
#endif
const size_t SamplingGrid::getDiscreteWindowLengthPerAxis(const size_t axis) const
{
  const double round_offset =
      (std::numeric_limits<size_t>::round_style == std::round_toward_zero) ?
          0.5 : 0.; // need offset to get to round_toward_nearest behavior
  const double length =
    (double)getGridPointsPerAxis()*getWindowLengthPerAxis(axis)/getTotalLengthPerAxis(axis)+round_offset;
  return length;
}

#ifdef HAVE_INLINE
inline
#endif
const size_t SamplingGrid::getWindowGridPoints() const
{
  return getWindowGridPointsPerAxis(0)
      *getWindowGridPointsPerAxis(1)
      *getWindowGridPointsPerAxis(2);
}

#ifdef HAVE_INLINE
inline
#endif
void SamplingGrid::setDomainSize(
    const double _begin[NDIM],
    const double _end[NDIM])
{
  for (size_t index=0;index<NDIM;++index) {
    begin[index] = _begin[index];
    end[index] = _end[index];
  }
}

#endif /* SAMPLINGGRID_INLINE_HPP_ */
