/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2015 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * MoleculeObserver.cpp
 *
 *  Created on: Dec 28, 2015
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <boost/assign.hpp>

#include "CodePatterns/Singleton_impl.hpp"

#include "molecule.hpp"

#include "MoleculeObserver.hpp"

using namespace boost::assign;

static const Observable::channels_t getMoleculeChannels()
{
  Observable::channels_t channels;
  for (int i=0;i<molecule::NotificationType_MAX; ++i)
    channels += (enum molecule::NotificationType)i;
  return channels;
}

const Observable::channels_t MoleculeObserver::MoleculeChannels(getMoleculeChannels());

MoleculeObserver::MoleculeObserver() :
    EntityObserver<molecule>(MoleculeChannels, std::string("MoleculeObserver"))
{}

CONSTRUCT_SINGLETON(MoleculeObserver)
