/*
 * ContinuousParameter_impl.hpp
 *
 *  Created on: Sep 30, 2011
 *      Author: heber
 */

#ifndef CONTINUOUSPARAMETER_IMPL_HPP_
#define CONTINUOUSPARAMETER_IMPL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <limits>

#include "ContinuousParameter.hpp"

/** Constructor for class ContinuousParameter.
 *
 */
template<typename T>
ContinuousParameter<T>::ContinuousParameter(const std::string &_name) :
  Parameter(_name),
  ContinuousValue<T>(range<T>(std::numeric_limits<T>::min(), std::numeric_limits<T>::max()))
{};

/** Constructor for class ContinuousParameter.
 *
 * @param _name name of this parameter
 * @param _value initial value to set
 */
template<typename T>
ContinuousParameter<T>::ContinuousParameter(const std::string &_name, const T &_value) :
  Parameter(_name),
  ContinuousValue<T>(range<T>(std::numeric_limits<T>::min(), std::numeric_limits<T>::max()))
{
  setValue(_value);
};

/** Constructor for class ContinuousParameter.
 *
 * @param _name name of this parameter
 * @param _ValidRange valid range for this ContinuousValue
 */
template<typename T>
ContinuousParameter<T>::ContinuousParameter(const std::string &_name, const range<T> &_ValidRange) :
  Parameter(_name),
  ContinuousValue<T>(_ValidRange)
{};

/** Constructor for class ContinuousParameter.
 *
 * @param _name name of this parameter
 * @param _ValidRange valid range for this ContinuousValue
 * @param _value initial value to set
 */
template<typename T>
ContinuousParameter<T>::ContinuousParameter(const std::string &_name, const range<T> &_ValidRange, const T &_value) :
  Parameter(_name),
  ContinuousValue<T>(_ValidRange)
{
  setValue(_value);
};

/** Destructor for class ContinuousParameter.
 *
 */
template<typename T>
ContinuousParameter<T>::~ContinuousParameter()
{};

/** Compares this continuous value against another \a _instance.
 *
 * @param _instance other value to compare to
 * @return true - if contained ContinuousValue and name are the same, false - else
 */
template <class T>
bool ContinuousParameter<T>::operator==(const ContinuousParameter<T> &_instance) const
{
  bool status = true;
  status = status &&
      (*dynamic_cast<const ContinuousValue<T> *>(this) == dynamic_cast<const ContinuousValue<T> &>(_instance));
  status = status && (Parameter::getName() == _instance.Parameter::getName());
  return status;
}

/** Creates a clone of this Parameter instance.
 *
 * @return cloned instance
 */
template<typename T>
Parameter* ContinuousParameter<T>::clone() const
{
  ContinuousParameter<T> *instance = new ContinuousParameter<T>(Parameter::getName(), ContinuousValue<T>::getValidRange());
  instance->setValue(ContinuousValue<T>::getValue());
  return instance;
}


#endif /* CONTINUOUSPARAMETER_IMPL_HPP_ */
