/*
 * Calculation_impl.hpp
 *
 *  Created on: Feb 19, 2010
 *      Author: crueger
 */

#ifndef CALCULATION_IMPL_HPP_
#define CALCULATION_IMPL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "Actions/Calculation.hpp"

#include <cassert>
#include <iostream>

using namespace MoleCuilder;

template<typename T>
Calculation<T>::Calculation(int _maxSteps, const ActionTrait &_trait) :
  Process(_trait),
  result(0),
  done(false)
{
  setMaxSteps(_maxSteps);
}

template<typename T>
Calculation<T>::~Calculation()
{
  delete result;
}

// methods inherited from Action

template<typename T>
ActionState::ptr Calculation<T>::performCall(){
  reset();
  (*this)();
  return Action::success;
}

template<typename T>
ActionState::ptr Calculation<T>::performUndo(ActionState::ptr){
  ASSERT(0,"Cannot undo a calculation");
  return Action::success;
}
template<typename T>
ActionState::ptr Calculation<T>::performRedo(ActionState::ptr){
  ASSERT(0,"Cannot redo a calculation");
  return Action::success;
}

template<typename T>
bool Calculation<T>::canUndo()
{
  return false;
}

template<typename T>
bool Calculation<T>::shouldUndo()
{
  return false;
}

template<typename T>
void Calculation<T>::outputAsCLI(std::ostream &ost) const
{
}

template<typename T>
void Calculation<T>::outputAsPython(std::ostream &ost, const std::string &prefix) const
{}

// methods for calculation infrastructure

template<typename T>
T Calculation<T>::operator()(){
  if(!done){
    result = doCalc();
    done = true;
  }
  return *result;
}

template<typename T>
bool Calculation<T>::hasResult() const {
  return done;
}

template<typename T>
T Calculation<T>::getResult() const {
  assert(done && "No result calculated");
  return *result;
}

template<typename T>
void Calculation<T>::reset(){
  done = false;
  delete result;
  result = 0;
}

#endif /* CALCULATION_IMPL_HPP_ */
