/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * StreamStringView.cpp
 *
 *  Created on: Dec 14, 2009
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include <sstream>
#include <iostream>

#include "StreamStringView.hpp"

using namespace std;

StreamStringView::StreamStringView(boost::function<void(ostream *)> _displayMethod) :
  StringView(),
  displayMethod(_displayMethod)
{}

StreamStringView::~StreamStringView()
{}

const string StreamStringView::toString() {
  stringstream s;
  displayMethod(dynamic_cast<ostream *>(&s));
  return s.str();
}
