/*
 * AtomDescriptorUnitTest.hpp
 *
 *  Created on: Feb 9, 2010
 *      Author: crueger
 */

#ifndef ATOMDESCRIPTORUNITTEST_HPP_
#define ATOMDESCRIPTORUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

#include "types.hpp"

// we prefer enum over define
enum { ATOM_COUNT = 10 };

class atom;

class AtomDescriptorTest : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( AtomDescriptorTest );
  CPPUNIT_TEST ( AtomBaseSetsTest );
  CPPUNIT_TEST ( AtomIdTest );
  CPPUNIT_TEST ( AtomOfMoleculeTest );
  CPPUNIT_TEST ( AtomsWithinDistanceOfTest );
  CPPUNIT_TEST ( AtomCalcTest );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp();
  void tearDown();

  void AtomBaseSetsTest();
  void AtomOfMoleculeTest();
  void AtomIdTest();
  void AtomsWithinDistanceOfTest();
  void AtomCalcTest();

private:
  atom *atoms [ATOM_COUNT];
  atomId_t atomIds [ATOM_COUNT];
};

#endif /* ATOMDESCRIPTORUNITTEST_HPP_ */
