/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * RandomNumberDistribution_ParametersTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include "RandomNumbers/RandomNumberDistribution_Parameters.hpp"

TextDialog::RandomNumberDistribution_ParametersTextQuery::RandomNumberDistribution_ParametersTextQuery(Parameter<RandomNumberDistribution_Parameters> &_param, std::string title, std::string _description) :
    Dialog::TQuery<RandomNumberDistribution_Parameters>(_param, title,_description)
{}

TextDialog::RandomNumberDistribution_ParametersTextQuery::~RandomNumberDistribution_ParametersTextQuery() {}

bool TextDialog::RandomNumberDistribution_ParametersTextQuery::handle() {
  bool badInput = false;
  do{
    badInput = false;
    std::cout << getDescription() << ": " << std::endl;
    std::cout << "Please enter parameters as follows: 'p=0.5;'";
    std::cout << "Empty line terminates." << std::endl;
    std::cin >> temp;
    if(std::cin.fail()){
      badInput = true;
      std::cin.clear();
      std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
      std::cout << "Input was not a number!" << std::endl;
      continue;
    }

  } while(badInput);
  std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
  return true;
}


