/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * GraphEdge.cpp
 *
 *  Created on: Feb 25, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Bond/GraphEdge.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

GraphEdge::GraphEdge() :
  Cyclic(false),
  Type(Undetermined),
  Used(white)
{}

GraphEdge::~GraphEdge()
{}

enum GraphEdge::Shading GraphEdge::IsUsed()
{
  return Used;
};

bool GraphEdge::MarkUsed(const enum GraphEdge::Shading color)
{
  if (Used == black) {
    ELOG(1, "GraphEdge " << this << " was already marked black!.");
    return false;
  } else {
    Used = color;
    return true;
  }
};

void GraphEdge::ResetUsed()
{
  Used = white;
};

string GraphEdge::getColorName(enum Shading color)
{
  switch (color) {
    case white:
      return "white";
      break;
    case lightgray:
      return "lightgray";
      break;
    case darkgray:
      return "darkgray";
      break;
    case black:
      return "black";
      break;
    default:
      return "uncolored";
      break;
  };
}
