/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2015 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * KeyValuePairQtQuery.cpp
 *
 *  Created on: May 16, 2015
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qlabel.h>
#include <Qt/qlineedit.h>
#include <Qt/qcombobox.h>

//#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"

#include "Parameters/Specifics/KeyValuePair.hpp"

QtDialog::KeyValuePairQtQuery::KeyValuePairQtQuery(Parameter<KeyValuePair> &_param, const std::string &_title, const std::string &_description,QBoxLayout *_parent,Dialog *_dialog) :
    QtQuery<KeyValuePair>(_param, _title, _description),
    parent(_parent),
    dialog(_dialog)
{
  temp.clear();
  if (param.isSet())
    temp = param.get();
  thisLayout = new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));
  titleLabel->setToolTip(QString(getDescription().c_str()));
  parent->addLayout(thisLayout);
  thisLayout->addWidget(titleLabel);

  if (dynamic_cast<DiscreteValidator<KeyValuePair>*>(&_param.getValidator()) != NULL){
    // Discrete set of valid string -> use a ComboBox.

    const std::vector<std::string> &strings = dynamic_cast<DiscreteValidator<std::string>*>(&_param.getValidator())->getValidValues();
    comboBox = new QComboBox();
    for(vector<std::string>::const_iterator iter  = strings.begin();
        iter != strings.end();
        ++iter) {
      comboBox->addItem(QString((*iter).c_str()));
    }
    thisLayout->addWidget(comboBox);

    connect(comboBox,SIGNAL(currentIndexChanged(int)),this,SLOT(onUpdateCombo(int)));
    onUpdateCombo(0);
  }else{
    // Use a LineEdit.
    inputBox = new QLineEdit(QString(temp.c_str()));
    thisLayout->addWidget(inputBox);

    onUpdate(inputBox->text());
    connect(inputBox,SIGNAL(textChanged(const QString&)),this,SLOT(onUpdate(const QString&)));
  }
}

QtDialog::KeyValuePairQtQuery::~KeyValuePairQtQuery()
{
}

void QtDialog::KeyValuePairQtQuery::onUpdate(const QString& newText) {
  temp = newText.toStdString();
  dialog->update();
}

void QtDialog::KeyValuePairQtQuery::onUpdateCombo(int newIndex) {
  temp = comboBox->itemText(newIndex).toStdString();
  dialog->update();
}

