/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * MoleculeOfAtomSelectionDescriptor.cpp
 *
 *  Created on: Dec 11, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/MoleculeIdDescriptor.hpp"
#include "Descriptors/MoleculeOfAtomSelectionDescriptor.hpp"
#include "Descriptors/MoleculeOfAtomSelectionDescriptor_impl.hpp"

#include "Helpers/helpers.hpp"

#include "molecule.hpp"
#include "World.hpp"

MoleculeOfAtomSelectionDescriptor_impl::MoleculeOfAtomSelectionDescriptor_impl(){}

MoleculeOfAtomSelectionDescriptor_impl::~MoleculeOfAtomSelectionDescriptor_impl(){}

bool MoleculeOfAtomSelectionDescriptor_impl::predicate(const std::pair<moleculeId_t,const molecule*> molecule) const{
  for (molecule::const_iterator iter = molecule.second->begin();
      iter != molecule.second->end();
      ++iter) {
    if (World::getInstance().isSelected(*iter))
      return true;
  }
  return false;
}

molecule* MoleculeOfAtomSelectionDescriptor_impl::find(){
  World::AtomSet &set = getSelectedAtoms();
  for (World::AtomSet::internal_iterator iter = set.begin_internal();
      iter != set.end_internal();
      ++iter) {
    if (iter->second->getMolecule()) {
      return World::getInstance().getMolecule(MoleculeById(iter->second->getMolecule()->getId()));
    }
  }
  return 0;
}

const molecule* MoleculeOfAtomSelectionDescriptor_impl::find() const {
  const World::AtomSet &set = getSelectedAtoms();
  for (World::AtomSet::const_iterator iter = set.begin();
      iter != set.end();
      ++iter) {
    if (iter->second->getMolecule())
      return iter->second->getMolecule();
  }
  return 0;
}

std::vector<molecule*> MoleculeOfAtomSelectionDescriptor_impl::findAll(){
  std::vector<molecule*> res;
  std::set<molecule*> temp;
  std::pair< std::set<molecule*>::iterator, bool> inserter;
  World::AtomSet &set = getSelectedAtoms();
  for (World::AtomSet::internal_iterator iter = set.begin_internal();
      iter != set.end_internal();
      ++iter) {
    if (iter->second->getMolecule() != NULL) {
      // get as non-const version
      molecule * const _mol =
          World::getInstance().getMolecule(
              MoleculeById(iter->second->getMolecule()->getId()));
      inserter = temp.insert( _mol );
      if (inserter.second)
        res.push_back(_mol);
    }
  }
  return res;
}

std::vector<const molecule*> MoleculeOfAtomSelectionDescriptor_impl::findAll() const {
  std::vector<const molecule*> res;
  std::set<const molecule*> temp;
  std::pair< std::set<const molecule*>::iterator, bool> inserter;
  const World::AtomSet &set = getSelectedAtoms();
  for (World::AtomSet::const_iterator iter = set.begin();
      iter != set.end();
      ++iter) {
    const molecule * const _mol = iter->second->getMolecule();
    if ( _mol != NULL ) {
      inserter = temp.insert( _mol );
      if (inserter.second)
        res.push_back(_mol);
    }
  }
  return res;
}

World::AtomSet& MoleculeOfAtomSelectionDescriptor_impl::getSelectedAtoms(){
  return World::getInstance().selectedAtoms;
}

const World::AtomSet& MoleculeOfAtomSelectionDescriptor_impl::getSelectedAtoms() const{
  return World::getInstance().selectedAtoms;
}

MoleculeDescriptor MoleculesByAtomSelection(){
  return MoleculeDescriptor(MoleculeDescriptor::impl_ptr(new MoleculeOfAtomSelectionDescriptor_impl()));
}
