/*
 * OutputAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/WorldAction/OutputAction.hpp"
#include "Actions/ActionCalls.hpp"
#include "Parser/ChangeTracker.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

const char WorldOutputAction::NAME[] = "output";

WorldOutputAction::WorldOutputAction() :
  Action(NAME)
{}

WorldOutputAction::~WorldOutputAction()
{}

void WorldOutput() {
  ActionRegistry::getInstance().getActionByName(WorldOutputAction::NAME)->call(Action::NonInteractive);
};

Dialog* WorldOutputAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryEmpty(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr WorldOutputAction::performCall() {

  DoLog(0) && (Log() << Verbose(0) << "Saving world to files." << endl);
  ChangeTracker::getInstance().saveStatus();
  return Action::success;
}

Action::state_ptr WorldOutputAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldOutputAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldOutputAction::canUndo() {
  return false;
}

bool WorldOutputAction::shouldUndo() {
  return false;
}

const string WorldOutputAction::getName() {
  return NAME;
}
