/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * StringsTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"


TextDialog::StringsTextQuery::StringsTextQuery(Parameter<std::vector<std::string> > &_param, std::string title, std::string _description) :
    Dialog::StringsQuery(_param, title,_description)
{}

TextDialog::StringsTextQuery::~StringsTextQuery() {}

bool TextDialog::StringsTextQuery::handle() {
  std::cout << getDescription() << ": ";
  getline(std::cin,temp_element);
  // dissect by " "
  std::string::iterator olditer = temp_element.begin();
  for(std::string::iterator iter = temp_element.begin(); iter != temp_element.end(); ++iter) {
    if (*iter == ' ') {
      temp.push_back(std::string(iter, olditer));
      olditer = iter;
    }
  }
  if (olditer != temp_element.begin())  // insert last part also
    temp.push_back(std::string(olditer, temp_element.end()));
  param.set(temp);

  return true;
}

