/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * VectorCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Actions/Values.hpp"
#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Box.hpp"
#include "World.hpp"

CommandLineDialog::VectorCommandLineQuery::VectorCommandLineQuery(Parameter<Vector> &_param, std::string title, std::string _description) :
    Dialog::VectorQuery(_param, title, _description)
{}

CommandLineDialog::VectorCommandLineQuery::~VectorCommandLineQuery()
{}

bool CommandLineDialog::VectorCommandLineQuery::handle() {
  VectorValue _temp;
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    _temp = CommandLineParser::getInstance().vm[getTitle()].as< VectorValue >();
    temp = _temp.toVector();
    param.set(temp);
    return true;
  } else {
    ELOG(1, "CommandLineUI parsing error: Missing vector for " << getTitle() << ".");
    return false;
  }
}

