/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * BoxCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Actions/Values.hpp"
#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"

CommandLineDialog::RealSpaceMatrixCommandLineQuery::RealSpaceMatrixCommandLineQuery(Parameter<RealSpaceMatrix> &_param, std::string title, std::string _description) :
    Dialog::RealSpaceMatrixQuery(_param, title, _description)
{}

CommandLineDialog::RealSpaceMatrixCommandLineQuery::~RealSpaceMatrixCommandLineQuery()
{}

bool CommandLineDialog::RealSpaceMatrixCommandLineQuery::handle() {
  RealSpaceMatrixValue _temp;
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    _temp = CommandLineParser::getInstance().vm[getTitle()].as< RealSpaceMatrixValue >();
    param.set(_temp.toRealSpaceMatrix());
    return true;
  } else {
    ELOG(1, "CommandLineUI parsing error: Missing symmetric box matrix for " << getTitle() << ".");
    return false;
  }
}

