/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * DoubleCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"


CommandLineDialog::DoubleCommandLineQuery::DoubleCommandLineQuery(Parameter<double> &_param, std::string title, std::string _description) :
    Dialog::DoubleQuery(_param, title, _description)
{}

CommandLineDialog::DoubleCommandLineQuery::~DoubleCommandLineQuery() {}

bool CommandLineDialog::DoubleCommandLineQuery::handle() {
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    param.set(CommandLineParser::getInstance().vm[getTitle()].as<double>());
    return true;
  } else {
    ELOG(1, "CommandLineUI parsing error: Missing double for " << getTitle() << ".");
    return false;
  }
}

