/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomsCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include <Descriptors/AtomDescriptor.hpp>
#include <Descriptors/AtomIdDescriptor.hpp>
#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

CommandLineDialog::AtomsCommandLineQuery::AtomsCommandLineQuery(string title, string _description) :
    Dialog::AtomsQuery(title, _description)
{}

CommandLineDialog::AtomsCommandLineQuery::~AtomsCommandLineQuery() {}

bool CommandLineDialog::AtomsCommandLineQuery::handle() {
  std::vector<int> IdxOfAtom;
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    IdxOfAtom = CommandLineParser::getInstance().vm[getTitle()].as< std::vector<int> >();
    for (std::vector<int>::iterator iter = IdxOfAtom.begin(); iter != IdxOfAtom.end(); ++iter) {
      temp = World::getInstance().getAtom(AtomById(*iter));
      if (temp)
        tmp.push_back(temp);
    }
    return true;
  } else {
    DoeLog(1) && (eLog() << Verbose(1) << "CommandLineUI parsing error: Missing atoms for " << getTitle() << "." << endl);
    return false;
  }
}

