/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FileTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>
#include <string>

#include <boost/filesystem.hpp>

#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"


TextDialog::FileTextQuery::FileTextQuery(std::string title, std::string _description) :
    Dialog::FileQuery(title,_description)
{}

TextDialog::FileTextQuery::~FileTextQuery() {}

bool TextDialog::FileTextQuery::handle() {
  bool badInput = false;
  std::string tempstring;
  do{
    badInput = false;
    std::cout << getDescription() << ": ";
    std::cin >> tempstring;
    if(std::cin.fail()){
      badInput = true;
      std::cin.clear();
      std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
      std::cout << "Input was not a number!" << std::endl;
      continue;
    }
  } while(badInput);
  std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
  tmp = tempstring;
  return true;
}

