/*
 * SaveAdjacencyAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/SaveAdjacencyAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "bondgraph.hpp"
#include "config.hpp"
#include "Helpers/Log.hpp"
#include "molecule.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"


#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"

/****** MoleculeSaveAdjacencyAction *****/

// memento to remember the state when undoing

//class MoleculeSaveAdjacencyState : public ActionState {
//public:
//  MoleculeSaveAdjacencyState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char MoleculeSaveAdjacencyAction::NAME[] = "save-adjacency";

MoleculeSaveAdjacencyAction::MoleculeSaveAdjacencyAction() :
  Action(NAME)
{}

MoleculeSaveAdjacencyAction::~MoleculeSaveAdjacencyAction()
{}

void MoleculeSaveAdjacency(std::string &adjacencyfile) {
  ValueStorage::getInstance().setCurrentValue(MoleculeSaveAdjacencyAction::NAME, adjacencyfile);
  ActionRegistry::getInstance().getActionByName(MoleculeSaveAdjacencyAction::NAME)->call(Action::NonInteractive);
};

Dialog* MoleculeSaveAdjacencyAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryString(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr MoleculeSaveAdjacencyAction::performCall() {
  string filename;
  molecule *mol = NULL;

  ValueStorage::getInstance().queryCurrentValue(NAME, filename);

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    DoLog(0) && (Log() << Verbose(0) << "Storing adjacency to path " << filename << "." << endl);
    World::getInstance().getConfig()->BG->ConstructBondGraph(mol);
    // TODO: sollte stream nicht filename benutzen, besser fuer unit test
    mol->StoreAdjacencyToFile(filename);
  }
  return Action::success;
}

Action::state_ptr MoleculeSaveAdjacencyAction::performUndo(Action::state_ptr _state) {
//  MoleculeSaveAdjacencyState *state = assert_cast<MoleculeSaveAdjacencyState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeSaveAdjacencyAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeSaveAdjacencyAction::canUndo() {
  return false;
}

bool MoleculeSaveAdjacencyAction::shouldUndo() {
  return false;
}

const string MoleculeSaveAdjacencyAction::getName() {
  return NAME;
}
