/*
 * logger.cpp
 *
 *  Created on: Oct 19, 2009
 *      Author: metzler
 */

#include "Helpers/MemDebug.hpp"

#include <fstream>
#include <iostream>
#include "Helpers/logger.hpp"
#include "Helpers/Verbose.hpp"
#include "Patterns/Singleton_impl.hpp"

ofstream nullStream("/dev/null");

int logger::verbosity = 2;
ostream* logger::nix = &nullStream;

/**
 * Constructor. Do not use this function. Use getInstance() instead.
 *
 * \return logger instance
 */
logger::logger()
{};

/**
 * Destructor. Better use purgeInstance().
 */
logger::~logger() {}

CONSTRUCT_SINGLETON(logger)

/**
 * Sets the verbosity.
 *
 * \param verbosityLevel verbosity
 */
void logger::setVerbosity(int verbosityLevel) {
  verbosity = verbosityLevel;
}

/**
 * Gets the verbosity.
 *
 * \return verbosity level
 */
int logger::getVerbosity()
{
  return verbosity;
}

/**
 * Operator for the Binary(arg) call.
 * Constructs temporary a Verbose class object, wherein the Binary is stored.
 * Then << is called, which calls Binary's print which adds the tabs and logs
 * the stream.
 * \param &ost stream to extend
 * \param &m pointer to created Binary object
 * \return &ost
 */
ostream& operator<<(class logger& l, const Verbose& v)
{
  int verbosityLevel = l.verbosity;
  l.nix->clear();
  if (v.DoOutput(verbosityLevel)) {
    v.print(cout);
    return cout;
  } else
    return *l.nix;
};
ostream& operator<<(class logger* l, const Verbose& v)
{
  int verbosityLevel = l->verbosity;
  l->nix->clear();
  if (v.DoOutput(verbosityLevel)) {
    v.print(cout);
    return cout;
  } else
    return *l->nix;
};

