/*
 * atom_graphnodeinfo.hpp
 *
 *  Created on: Oct 19, 2009
 *      Author: heber
 */

#ifndef ATOM_GRAPHNODEINFO_HPP_
#define ATOM_GRAPHNODEINFO_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/****************************************** forward declarations *****************************/

class atom;

/********************************************** declarations *******************************/

class GraphNode;

class GraphNodeInfo {
public:

  int GraphNr;      //!< unique number, given in DepthFirstSearchAnalysis()
  int *ComponentNr;//!< belongs to this non-separable components, given in DepthFirstSearchAnalysis() (if more than one, then is SeparationVertex)
  int LowpointNr; //!< needed in DepthFirstSearchAnalysis() to detect non-separable components, is the lowest possible number of an atom to reach via tree edges only followed by at most one back edge.
  bool SeparationVertex; //!< whether this atom separates off subsets of atoms or not, determined in DepthFirstSearchAnalysis()
  bool IsCyclic;        //!< whether atom belong to as cycle or not, determined in DepthFirstSearchAnalysis()
  atom *Ancestor; //!< "Father" in Depth-First-Search

  GraphNodeInfo();
  virtual ~GraphNodeInfo();
private:

};

#endif /* ATOM_GRAPHNODEINFO_HPP_ */
