/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * IntCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "CommandLineUI/CommandLineDialog.hpp"

#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "CommandLineParser.hpp"

CommandLineDialog::IntCommandLineQuery::IntCommandLineQuery(string title, string _description) :
    Dialog::IntQuery(title, _description)
{}

CommandLineDialog::IntCommandLineQuery::~IntCommandLineQuery() {}

bool CommandLineDialog::IntCommandLineQuery::handle() {
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    tmp = CommandLineParser::getInstance().vm[getTitle()].as<int>();
    return true;
  } else {
    DoeLog(1) && (eLog() << Verbose(1) << "CommandLineUI parsing error: Missing integer for " << getTitle() << "." << endl);
    return false;
  }
}

