/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculesTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include <Descriptors/MoleculeDescriptor.hpp>
#include <Descriptors/MoleculeIdDescriptor.hpp>
#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"


TextDialog::MoleculesTextQuery::MoleculesTextQuery(Parameter<std::vector<const molecule *> > &_param, std::string title, std::string _description) :
    Dialog::TQuery<std::vector<const molecule *> >(_param, title,_description)
{}

TextDialog::MoleculesTextQuery::~MoleculesTextQuery() {}

bool TextDialog::MoleculesTextQuery::handle() {
  int idxOfMol=-1;
  std::cout << getDescription() << ": ";
  std::string line;
  getline(std::cin,line);
  // dissect by " "
  const molecule *temp_element;
  std::string::iterator olditer = line.begin();
  for(std::string::iterator iter = line.begin(); iter != line.end(); ++iter) {
    if (*iter == ' ') {
      std::istringstream stream(std::string(iter, olditer));
      stream >> idxOfMol;
      temp_element = World::getInstance().getMolecule(MoleculeById(idxOfMol));
      if(!temp_element && idxOfMol!=-1){
        std::cout << "Invalid Molecule Index" << idxOfMol << std::endl;
        break;
      }
      temp.push_back(temp_element);
      olditer = iter;
    }
  }
  if (olditer != line.begin()) { // insert last part also
    std::istringstream stream(std::string(olditer, line.end()));
    stream >> idxOfMol;
    temp_element = World::getInstance().getMolecule(MoleculeById(idxOfMol));
    if(!temp_element && idxOfMol!=-1){
      std::cout << "Invalid Molecule Index" << idxOfMol << std::endl;
      temp.push_back(temp_element);
    }
  }

  return (idxOfMol!=-1);
}

