/*
 * TextQuery.hpp
 *
 *  Created on: Nov 8, 2010
 *      Author: heber
 */

#ifndef TEXTQUERY_HPP_
#define TEXTQUERY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "TextUI/TextDialog.hpp"

class TextDialog::AtomTextQuery : public Dialog::TQuery<const atom *> {
public:
  AtomTextQuery(Parameter<const atom *> &, std::string title, std::string _description = NULL);
  virtual ~AtomTextQuery();
  virtual bool handle();
};

class TextDialog::AtomsTextQuery : public Dialog::TQuery<std::vector<const atom *> > {
public:
  AtomsTextQuery(Parameter<std::vector<const atom *> > &, std::string title, std::string _description = NULL);
  virtual ~AtomsTextQuery();
  virtual bool handle();
};

class TextDialog::BooleanTextQuery : public Dialog::TQuery<bool> {
public:
  BooleanTextQuery(Parameter<bool> &, std::string title, std::string _description = NULL);
  virtual ~BooleanTextQuery();
  virtual bool handle();
};

class TextDialog::RealSpaceMatrixTextQuery : public Dialog::TQuery<RealSpaceMatrix> {
public:
  RealSpaceMatrixTextQuery(Parameter<RealSpaceMatrix> &, std::string title, std::string _description = NULL);
  virtual ~RealSpaceMatrixTextQuery();
  virtual bool handle();
};

class TextDialog::DoubleTextQuery : public Dialog::TQuery<double> {
public:
  DoubleTextQuery(Parameter<double> &, std::string title, std::string _description = NULL);
  virtual ~DoubleTextQuery();
  virtual bool handle();
};

class TextDialog::DoublesTextQuery : public Dialog::TQuery<std::vector<double> > {
public:
  DoublesTextQuery(Parameter<std::vector<double> > &, std::string title, std::string _description = NULL);
  virtual ~DoublesTextQuery();
  virtual bool handle();
};

class TextDialog::ElementTextQuery : public Dialog::TQuery<const element *> {
public:
  ElementTextQuery(Parameter<const element *> &, std::string title, std::string _description = NULL);
  virtual ~ElementTextQuery();
  virtual bool handle();
};

class TextDialog::ElementsTextQuery : public Dialog::TQuery<std::vector<const element *> > {
public:
  ElementsTextQuery(Parameter<std::vector<const element *> > &, std::string title, std::string _description = NULL);
  virtual ~ElementsTextQuery();
  virtual bool handle();
};

class TextDialog::EmptyTextQuery : public Dialog::EmptyQuery {
public:
  EmptyTextQuery(std::string title, std::string _description = NULL);
  virtual ~EmptyTextQuery();
  virtual bool handle();
};

class TextDialog::FileTextQuery : public Dialog::TQuery<boost::filesystem::path> {
public:
  FileTextQuery(Parameter<boost::filesystem::path> &, std::string title, std::string _description = NULL);
  virtual ~FileTextQuery();
  virtual bool handle();
};

class TextDialog::FilesTextQuery : public Dialog::TQuery<std::vector<boost::filesystem::path> > {
public:
  FilesTextQuery(Parameter<std::vector< boost::filesystem::path> > &param, std::string title, std::string _description = NULL);
  virtual ~FilesTextQuery();
  virtual bool handle();
};

class TextDialog::IntTextQuery : public Dialog::TQuery<int> {
public:
  IntTextQuery(Parameter<int> &, std::string title, std::string _description = NULL);
  virtual ~IntTextQuery();
  virtual bool handle();
};

class TextDialog::IntsTextQuery : public Dialog::TQuery<std::vector<int> > {
public:
  IntsTextQuery(Parameter<std::vector<int> > &, std::string title, std::string _description = NULL);
  virtual ~IntsTextQuery();
  virtual bool handle();
};

class TextDialog::MoleculeTextQuery : public Dialog::TQuery<const molecule *> {
public:
  MoleculeTextQuery(Parameter<const molecule *> &, std::string title, std::string _description = NULL);
  virtual ~MoleculeTextQuery();
  virtual bool handle();
};

class TextDialog::MoleculesTextQuery : public Dialog::TQuery<std::vector<const molecule *> > {
public:
  MoleculesTextQuery(Parameter<std::vector<const molecule *> > &, std::string title, std::string _description = NULL);
  virtual ~MoleculesTextQuery();
  virtual bool handle();
};

class TextDialog::StringTextQuery : public Dialog::TQuery<std::string> {
public:
  StringTextQuery(Parameter<std::string> &, std::string title, std::string _description = NULL);
  virtual ~StringTextQuery();
  virtual bool handle();
};

class TextDialog::StringsTextQuery : public Dialog::TQuery<std::vector<std::string> > {
public:
  StringsTextQuery(Parameter<std::vector<std::string> > &, std::string title, std::string _description = NULL);
  virtual ~StringsTextQuery();
  virtual bool handle();
};

class TextDialog::UnsignedIntTextQuery : public Dialog::TQuery<unsigned int> {
public:
  UnsignedIntTextQuery(Parameter<unsigned int> &, std::string title, std::string _description = NULL);
  virtual ~UnsignedIntTextQuery();
  virtual bool handle();
};

class TextDialog::UnsignedIntsTextQuery : public Dialog::TQuery<std::vector<unsigned int> > {
public:
  UnsignedIntsTextQuery(Parameter<std::vector<unsigned int> > &, std::string title, std::string _description = NULL);
  virtual ~UnsignedIntsTextQuery();
  virtual bool handle();
};

class TextDialog::VectorTextQuery : public Dialog::TQuery<Vector> {
public:
  VectorTextQuery(Parameter<Vector> &, std::string title, std::string _description = NULL);
  virtual ~VectorTextQuery();
  virtual bool handle();
};

class TextDialog::VectorsTextQuery : public Dialog::TQuery<std::vector<Vector> > {
public:
  VectorsTextQuery(Parameter<std::vector<Vector> > &, std::string title, std::string _description = NULL);
  virtual ~VectorsTextQuery();
  virtual bool handle();
};

class TextDialog::RandomNumberDistribution_ParametersTextQuery : public Dialog::TQuery<RandomNumberDistribution_Parameters> {
public:
  RandomNumberDistribution_ParametersTextQuery(Parameter<RandomNumberDistribution_Parameters> &, std::string title, std::string _description = NULL);
  virtual ~RandomNumberDistribution_ParametersTextQuery();
  virtual bool handle();
};

#endif /* TEXTQUERY_HPP_ */
