/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomsTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <Descriptors/AtomDescriptor.hpp>
#include <Descriptors/AtomIdDescriptor.hpp>
#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

#include "Atom/atom.hpp"
#include "World.hpp"


TextDialog::AtomsTextQuery::AtomsTextQuery(Parameter<std::vector<const atom *> > &_param, std::string title, std::string _description) :
    Dialog::TQuery<std::vector<const atom *> >(_param, title,_description)
{}

TextDialog::AtomsTextQuery::~AtomsTextQuery() {}

bool TextDialog::AtomsTextQuery::handle() {
  int idxOfAtom=-1;
  std::cout << getDescription() << ": ";
  std::string line;
  getline(std::cin,line);
  // dissect by " "
  const atom *temp_element;
  std::string::iterator olditer = line.begin();
  for(std::string::iterator iter = line.begin(); iter != line.end(); ++iter) {
    if (*iter == ' ') {
      std::istringstream stream(std::string(iter, olditer));
      stream >> idxOfAtom;
      temp_element = World::getInstance().getAtom(AtomById(idxOfAtom));
      if(!temp_element && idxOfAtom!=-1){
        std::cout << "Invalid Atom Index" << idxOfAtom << std::endl;
        break;
      }
      temp.push_back(temp_element);
      olditer = iter;
    }
  }
  if (olditer != line.begin()) { // insert last part also
    std::istringstream stream(std::string(olditer, line.end()));
    stream >> idxOfAtom;
    temp_element = World::getInstance().getAtom(AtomById(idxOfAtom));
    if(!temp_element && idxOfAtom!=-1) {
      std::cout << "Invalid Atom Index" << idxOfAtom << std::endl;
      temp.push_back(temp_element);
    }
  }

  return (idxOfAtom!=-1);
}

