/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * StringQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qlabel.h>
#include <Qt/qlineedit.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"


QtDialog::StringQtQuery::StringQtQuery(Parameter<std::string> &_param, std::string _title,QBoxLayout *_parent,Dialog *_dialog) :
    QtQuery<std::string>(_param, _title),
    parent(_parent),
    dialog(_dialog)
{
  temp = "";
  if (param.isSet())
    temp = param.get();
  thisLayout = new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()));
  inputBox = new QLineEdit();
  parent->addLayout(thisLayout);
  thisLayout->addWidget(titleLabel);
  thisLayout->addWidget(inputBox);

  onUpdate(inputBox->text());
  connect(inputBox,SIGNAL(textChanged(const QString&)),this,SLOT(onUpdate(const QString&)));
}

QtDialog::StringQtQuery::~StringQtQuery()
{
}

void QtDialog::StringQtQuery::onUpdate(const QString& newText) {
  temp = newText.toStdString();
  dialog->update();
}

