/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * IntsCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

CommandLineDialog::IntsCommandLineQuery::IntsCommandLineQuery(Parameter<std::vector<int> > &_param, std::string title, std::string _description) :
    Dialog::TQuery<std::vector<int> >(_param, title, _description)
{}

CommandLineDialog::IntsCommandLineQuery::~IntsCommandLineQuery() {}

bool CommandLineDialog::IntsCommandLineQuery::handle() {
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    temp = CommandLineParser::getInstance().vm[getTitle()].as< std::vector<int> >();
    return true;
  } else {
    ELOG(1, "CommandLineUI parsing error: Missing integers for " << getTitle() << ".");
    return false;
  }
}

