/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include <Descriptors/AtomDescriptor.hpp>
#include <Descriptors/AtomIdDescriptor.hpp>

#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

using namespace std;

CommandLineDialog::AtomCommandLineQuery::AtomCommandLineQuery(Parameter<const atom *> &_param, std::string title, std::string _description) :
    Dialog::TQuery<const atom*>(_param, title, _description)
{}

CommandLineDialog::AtomCommandLineQuery::~AtomCommandLineQuery() {}

bool CommandLineDialog::AtomCommandLineQuery::handle() {
  int IdxOfAtom = -1;
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    IdxOfAtom = CommandLineParser::getInstance().vm[getTitle()].as<int>();
    temp = World::getInstance().getAtom(AtomById(IdxOfAtom));
    return true;
  } else {
    ELOG(1, "CommandLineUI parsing error: Missing atom for " << getTitle() << ".");
    return false;
  }
}

